local NO_FACT				= 65535
local NO_QUEST				= 255
local NO_QUOTE				= 255
local IRRELEVANT			= 255
local NO_MOVE				= -1

local QUOTE_FLAG_SAID				= 1 -- rekord zawsze uywany podczas rozmowy
local QUOTE_FLAG_ERASE_ONCE_SAID	= 2 -- rekord raz uywany podczas rozmowy
local QUOTE_FLAG_SAY_ONCE_PER_CONVO	= 4 -- uyj raz w dialogu

function NpcData (uiNPC)

		-- W katalogu "NPCData" musi znajdowa si plik "060.NPC". Inaczej ten skrypt lua niezostanie wykonany. 
		-- Jeeli w katalogu "NPCData" bdzie znajdowa si plik "060.NPC" i w katalogu "scripts\Legion2_NPCdata\" jest umieszczony plik 060.lua, 
		-- to gra w pierwszej kolejnoci wczyta rekordy ze skryptu "060.NPC", a nastpnie nadpisze te rekordy, ktre bd umieszczone w tym skrypcie.
		-- Jeeli w pliku "060.NPC", bd aktywne rekordy 0,1,2,3,4,5,6,7,10, to w tym skrypcie moemy umieci te same rekordy i one zostan nadpisane. 
		-- Moemy te umieci w tym skrypcie rekordy, ktrych nie ma w pliku "060.NPC" np.: 8,9,11,12 itd. Maksymalna ilo rekordw to 49,liczymy od zera.
		-- Moemy te zresetowa wszystkie rekordy do posta rekordw nieuywanych. Przykad poniej.
		
		--[[
		-- Resetuj wszystkie rekordy. 
		for Sloty = 0 , 49 do 
		ResetRecord = { }
		
		ResetRecord.UpdateRecord 		= true -- ustaw "true" by rekord zosta zaktualizowany. Zostaw "false" by nieaktualizowa tego rekordu.
		
		ResetRecord.Record 				= Sloty -- id rekordu
		ResetRecord.ubNPC 				= uiNPC -- numer postaci do ktrej jest przypisany rekord. Jeeli tworzymy plik np. 070.lua, to wpisujemy warto 70 lub zmienn uiNPC z funkcji "NpcData".
		
		ResetRecord.fFlags  			= QUOTE_FLAG_SAID -- flagi opisane na pocztku tego pliku
		
		ResetRecord.ubFirstDay 			= 0	-- Ustaw dzie od ktrego ten rekord bdzie aktywny.
		ResetRecord.ubLastDay  			= 0	-- Ustaw dzie do ktrego ten rekord bdzie aktywny. Ustaw ubLastDay 255, a ubFirstDay na 0, by ten rekord by do wykonania w kadym dniu. Ustaw w jednym i drugim zera aby rekord by wogle nieuywany.
		
		-- Wszysko to co ma wpyw na wykonanie tego rekordu.
		ResetRecord.sRequiredItem 		= 0	-- Jeeli my dajemy jaki przedmiot 
		ResetRecord.usFactMustBeTrue  	= NO_FACT	-- Jeeli jaki fakt jest speniony i jego warto jest "true". Podajemy id faktu.
		ResetRecord.usFactMustBeFalse  	= NO_FACT	-- Jeeli jaki fakt jest niespeniony i jego warto jest "false". Podajemy id faktu.
		ResetRecord.ubQuest  			= NO_QUEST	-- Jeeli jakie zadanie jest aktywne. Podajemy id zadania.
		ResetRecord.ubApproachRequired  = 0	-- must use this approach to generate quote
		ResetRecord.ubOpinionRequired  	= 0 -- ustawiamy wspczynnik LeaderShip jaki musi posiada nasz najemnik aby zostay wykonane opcje w sekcji "Actions". Wpisz 0 aby ignorowa t opcje.

		-- Akcje. 
		ResetRecord.ubQuoteNum  		= NO_QUOTE	-- this is the quote to say
		ResetRecord.ubNumQuotes  		= 0		-- total # of quotes to say
		
		ResetRecord.ubStartQuest  		= NO_QUEST
		ResetRecord.ubEndQuest 			= NO_QUEST
		ResetRecord.ubTriggerNPC  		= IRRELEVANT
		ResetRecord.ubTriggerNPCRec 	= 0
		ResetRecord.ubFiller  			= 0
		ResetRecord.usSetFactTrue  		= NO_FACT
		ResetRecord.usGiftItem  		= 0		-- item NPC gives to merc after saying quote
		ResetRecord.usUnused  			= 0
		ResetRecord.sActionData  		= 0		-- special action value	

		ResetRecord.sRequiredGridNo  		= NO_MOVE		-- location for NPC req'd to say quote
		ResetRecord.usGoToGridNo  			= NO_MOVE
		ResetRecord.usSourceDialogueLevel	= 0 -- reserved for future use
		ResetRecord.usDestDialogueLevel		= 0 -- reserved for future use
		
		Legion2_SetNPCRecordData(ResetRecord)
		end
		]]

		RecordUpdate60 = { }
		-- ustwa "true" by ustawi rekord. Gdy "false" rekord bdzie nienaruszony
		RecordUpdate60.UpdateRecord 		= true
		
		-- ktry rekord zaktualizowa
		RecordUpdate60.Record 				= 19
		RecordUpdate60.ubNPC 				= uiNPC
		
		RecordUpdate60.fFlags  				= 2
		
		-- conditions
		RecordUpdate60.sRequiredItem 		= 0	-- item NPC must have to say quote
		RecordUpdate60.usFactMustBeTrue  	= NO_FACT	-- ...before saying quote
		RecordUpdate60.usFactMustBeFalse  	= 369	-- ...before saying quote
		RecordUpdate60.ubQuest  			= NO_QUEST			-- quest must be current to say quote
		RecordUpdate60.ubFirstDay  			= 0			-- first day quote can be said
		RecordUpdate60.ubLastDay  			= 255		-- last day quote can be said
		RecordUpdate60.ubApproachRequired  	= 1	-- must use this approach to generate quote
		RecordUpdate60.ubOpinionRequired  	= 0 -- opinion needed for this quote

		-- quote to say (if any)
		RecordUpdate60.ubQuoteNum  			= 110			-- this is the quote to say
		RecordUpdate60.ubNumQuotes  		= 5		-- total # of quotes to say

		-- actions
		RecordUpdate60.ubStartQuest  		= 0
		RecordUpdate60.ubEndQuest 			= NO_QUEST
		RecordUpdate60.ubTriggerNPC  		= 60
		RecordUpdate60.ubTriggerNPCRec 		= 18
		RecordUpdate60.ubFiller  			= 0
		RecordUpdate60.usSetFactTrue  		= NO_FACT
		RecordUpdate60.usGiftItem  			= 0		-- item NPC gives to merc after saying quote
		RecordUpdate60.usUnused  			= 0
		RecordUpdate60.sActionData  		= 305		-- special action value	

		RecordUpdate60.sRequiredGridNo 			= NO_MOVE		-- location for NPC req'd to say quote
		RecordUpdate60.usGoToGridNo  			= NO_MOVE
		RecordUpdate60.usSourceDialogueLevel  	= 0 -- reserved for future use
		RecordUpdate60.usDestDialogueLevel  	= 0 -- reserved for future use
		
		Legion2_SetNPCRecordData(RecordUpdate60)
			
end